<?php

namespace Drupal\meta_conversions_api\Form;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\TypedConfigManagerInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\meta_conversions_api\Services\MetaClient;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Config form for Meta conversions API events.
 */
class EventsForm extends ConfigFormBase {

  /**
   * The Meta client.
   */
  protected MetaClient $metaClient;

  public function __construct(
    ConfigFactoryInterface $config_factory,
    TypedConfigManagerInterface $typed_config_manager,
    MetaClient $meta_client,
  ) {
    parent::__construct($config_factory, $typed_config_manager);

    $this->metaClient = $meta_client;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('config.typed'),
      $container->get('meta_conversions_api.meta_client')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'meta_conversions_api_events_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return [
      'meta_conversions_api.events',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['intro'] = [
      '#markup' => $this->t('Uncheck an event to prevent it from being sent to Meta. New events will be discovered when the cache is cleared.'),
    ];

    $eventNames = $this->metaClient->eventNames();

    $form['event_toggles'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Events'),
      '#options' => $eventNames,
      '#config_target' => 'meta_conversions_api.events:event_toggles',
    ];

    return parent::buildForm($form, $form_state);
  }

}
