<?php

namespace Drupal\meta_conversions_api;

use Drupal\meta_conversions_api\Services\MetaClientInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Twig extension to allow checking the Meta status from Twig templates.
 */
class MetaApiTwig extends AbstractExtension {

  /**
   * Meta API Client.
   */
  protected MetaClientInterface $metaClient;

  public function __construct(MetaClientInterface $meta_client) {
    $this->metaClient = $meta_client;
  }

  /**
   * {@inheritdoc}
   */
  public function getFunctions() {
    return [
      new TwigFunction('meta_api_is_enabled', [$this, 'isEnabled']),
      new TwigFunction('meta_api_is_allowed', [$this, 'isAllowed']),
    ];
  }

  /**
   * Check if Meta API is enabled and configured.
   *
   * @return bool
   *   TRUE if Meta events can be sent.
   *
   * @see \Drupal\meta_conversions_api\Services\MetaClient::isEnabled()
   */
  public function isEnabled(): bool {
    return $this->metaClient->isEnabled();
  }

  /**
   * Check if Meta API is allowed to send requests.
   *
   * It can be blocked by a module, for example, if the user has not consented
   * to be tracked.
   *
   * @return bool
   *   TRUE if Meta events should be sent.
   *
   * @see \Drupal\meta_conversions_api\Services\MetaClient::isAllowed()
   */
  public function isAllowed(): bool {
    return $this->metaClient->isAllowed();
  }

}
