<?php

namespace Drupal\meta_conversions_api\Services;

/**
 * Provides an interface for the MetaClient service.
 */
interface MetaClientInterface {

  /**
   * Check whether sending events is allowed.
   *
   * @return bool
   *   TRUE if no module has objected to sending events.
   *
   * @see hook_meta_conversions_api_allowed();
   */
  public function isAllowed(): bool;

  /**
   * Check if Meta API is enabled.
   *
   * @return bool
   *   TRUE if enabled and able to send requests to Meta.
   */
  public function isEnabled(): bool;

  /**
   * Sends request to the Facebook client.
   *
   * @param array $eventData
   *   The event data. Must contain 'event_name'. Other fields will be set to
   *   defaults if not specified.
   * @param array $userData
   *   Array of user data. If not provided client_ip_address and
   *   client_user_agent will be set automatically.
   * @param array $customData
   *   Array of custom data.
   * @param string|null $testEventCode
   *   Meta test event code.
   *
   * @see \FacebookAds\Object\ServerSide\Event::__construct()
   * @see \FacebookAds\Object\ServerSide\UserData::__construct()
   * @see \FacebookAds\Object\ServerSide\CustomData::__construct()
   */
  public function sendRequest(array $eventData, array $userData = [], array $customData = [], ?string $testEventCode = NULL): void;

  /**
   * Get event names.
   *
   * @return array
   *   Array of event names, where the keys are the declared names and the
   *   values are the names to be used.
   */
  public function eventNames(): array;

  /**
   * Check whether an event should be sent.
   *
   * @param string $eventName
   *   The event name as declared.
   *
   * @return bool
   *   TRUE if the event is enabled, FALSE otherwise.
   */
  public function isEventEnabled($eventName): bool;

}
