# Meta Pixel

Provides Meta (Facebook) Pixel tracking for Drupal 10+ with both browser-side
and server-side (Conversions API) event tracking.

## Features

- Browser-side JavaScript pixel (fbq) tracking
- Server-side Conversions API tracking
- Event deduplication between browser and server
- Plugin-based event system for extensibility
- Privacy controls (EU Cookie Compliance, Do Not Track)
- Per-event configuration (enable/disable browser/CAPI independently)

## Requirements

- Drupal 10 or 11
- Commerce (If you want to track commerce events)
- Facebook PHP Business SDK (Automatically added as a dependency when you use
  composer)

## Installation

1. Install with composer `require drupal/meta_pixel`
2. The `facebook/php-business-sdk` and `facebook/capi-param-builder-php` libraries will be downloaded as composer dependencies,
   this is needed for the meta conversions api.
3. Enable with `drush en meta_pixel` and `drush en meta_pixel_commerce` (If you
   are using commerce)

## Configuration

1. Navigate to **Configuration > Services > Meta Pixel** (
   `/admin/config/services/meta-pixel`)
2. Enter your Meta Pixel ID (this is required)
3. (Optional) For CAPI Support: Enter your Conversions API Access Token
4. Configure privacy and visibility settings as needed
5. Navigate to the **Events** tab to enable/disable specific events for browser
   and CAPI tracking. All the events are disabled by default.

## Supported Events

**Core Module:**

- PageView
- CompleteRegistration
- ViewContent (nodes)

**Commerce Submodule:**

- ViewContent (products)
- AddToCart
- InitiateCheckout
- AddPaymentInfo
- Purchase

## Configuring Event Emitters

Most of the standard events work out of the box and don't require any configuration other than enabling it in the config form (`/admin/config/services/meta-pixel/events`), however there are a few cases you should be aware of that require some additional configuration.

### ViewContent Event

The ViewContent event is triggered via a lazy builder to maintain proper page caching. There is a pseudo field that you can enable for `node` and `commerce_product` entities per view mode using the field UI. It's recommended to only include this event on key content (not every page view) such as products and landing pages.

**To enable:**
1. Navigate to the display settings for your content type or product type
2. Enable the "Meta Pixel ViewContent Emitter" pseudo field
3. Make sure the ViewContent event is enabled at `/admin/config/services/meta-pixel/events`

With commerce_products, this event is also triggered when the variation changes via the select box in the add to cart form.

### Block Emitter

There is also a "Meta Pixel Event Emitter" block that you can place anywhere on your site. This block will fire the configured event whenever the block is viewed. This is typically used to trigger a custom event for a section of the site.

There is a block config option to display the data sent in the block output while debugging.

### PageView Event

The PageView event is handled differently from other events since it typically fires on every page load.

**Browser pixel (fbq):** When enabled, the PageView event is included in the base pixel code and fires automatically on every page where the pixel loads.

**CAPI:** When server-side tracking is enabled for PageView, it's triggered via an AJAX callback to `/ajax/pageview`. This approach allows the page itself to remain fully cacheable for anonymous users while still sending server-side events to Meta's Conversions API.

Unlike the other events, the PageView event ID is generated client side and then passed back to the server in the query params of the ajax url. This prevents having to generate the ID server-side and adding it to drupalSettings which would break anonymous page caching.

## Creating Custom Events

Developers can create custom event plugins by extending
`MetaPixelEventPluginBase`. See `meta_pixel.api.php` for examples and
documentation.

Also have a look at the existing plugins in `/src/Plugin/MetaPixelEvent` of both
`meta_pixel` and the `meta_pixel_commerce` submodule.

The plugin sets the data sent to Meta. Once that's set up you call the plugin
like this:

```php
\Drupal::service('meta_pixel.event_collector')->addEvent('PLUGIN_ID', $data, $use_session);
```

Where `$data` is an array of entities the plugin will need in order to extract
the data to send (product, order, node). Have a look at some of the included
plugins to see what's going on. It's fairly simple.

`$use_session` is a boolean value. If true it will store the event in the
session and add it to the `drupalSettings` array on the next page (form
submissions). When it is false it will be added to the `drupalSettings` array on
that request. This is only for browser events, the CAPI events are sent
immediately when you call `addEvent`.

## Alter Hook

You can alter both the **event_data** and **user_data** for each event fired
using the following hook:

```php
hook_meta_pixel_event_data_alter(array &$event_data, array &$user_data, array $context = [])
```

Refer to `meta_pixel.api.php` for examples.

Also, take a look at `meta_pixel_commerce_meta_pixel_event_data_alter()` to see
how the submodule adds customer profile data.

## Adding User Data to Events

In order to pass user data to Meta for better matching/reporting you will want
to implement the alter hook and add to the `$user_data` array. By default, it
will add the email from the user account and order, as well as any
billing/shipping profile info.

Most people will want to pass more from their user profiles. Since every site
is set up a little different and stores user profile fields differently (name,
address, etc.) In order to send that data along with the event you will need to add to the
`$user_data['profiles']`  array. You can also change the data already added or
unset it if you don't want to send any.

@see `meta_pixel.api.php` for an example of adding custom user data to CAPI.


## Credits

Inspired by and some code borrowed from:

- [facebook_pixel](https://www.drupal.org/project/facebook_pixel)
- [meta_conversions_api](https://www.drupal.org/project/meta_conversions_api)
- [google_tag](https://www.drupal.org/project/google_tag)

## Maintainers

- Loze - [loze](https://www.drupal.org/u/loze)

## More examples

Trigger a custom event.

1. Enable the custom event plugin on the settings page
2. Add the following code wherever you want to trigger the event.

```php
// A unique event id is automatically generated.
$this->eventCollector->addEvent('custom_event', [
    'event_name' => 'MyCustomEventName',
    'my_custom_param' => 'my_custom_value',
    'my_custom_param2' => 'my_custom_value2',
]);
```
