/**
 * @file
 * Meta Pixel AJAX command handler.
 */

/* global fbq */

(function (Drupal, drupalSettings) {
  /**
   * Custom AJAX command to fire Meta Pixel events.
   *
   * @param {object} ajax
   *   The AJAX object.
   * @param {object} response
   *   The response object.
   */
  Drupal.AjaxCommands.prototype.metaPixelTrack = function (ajax, response) {
    if (typeof fbq === 'function') {
      const options = { eventID: response.eventId };
      if (drupalSettings.metaPixel.debug) {
        // eslint-disable-next-line no-console
        console.log(
          'Ajax Command',
          response.eventName,
          response.eventData,
          options,
        );
      }
      fbq('track', response.eventName, response.eventData, options);
    }
  };
})(Drupal, drupalSettings);
