<?php

declare(strict_types=1);

namespace Drupal\meta_pixel\Ajax;

use Drupal\Core\Ajax\CommandInterface;
use Drupal\Core\Ajax\CommandWithAttachedAssetsInterface;
use Drupal\Core\Asset\AttachedAssets;

/**
 * AJAX command to fire Meta Pixel events.
 */
class MetaPixelTrackCommand implements CommandInterface, CommandWithAttachedAssetsInterface {

  /**
   * The event name.
   *
   * @var string
   */
  protected string $eventName;

  /**
   * The event data.
   *
   * @var array
   */
  protected array $eventData;

  /**
   * The event id.
   *
   * @var string
   */
  protected string $eventId;

  /**
   * Constructs a MetaPixelCommand object.
   *
   * @param string $eventName
   *   The Meta event name.
   * @param array $eventData
   *   The event data.
   * @param string $eventId
   *   The event ID for deduplication.
   */
  public function __construct(string $eventName, array $eventData, string $eventId) {
    $this->eventName = $eventName;
    $this->eventData = $eventData;
    $this->eventId = $eventId;
  }

  /**
   * {@inheritdoc}
   */
  public function render(): array {

    $render = [
      'command' => 'metaPixelTrack',
      'eventName' => $this->eventName,
      'eventData' => $this->eventData,
      'eventId' => $this->eventId,
    ];

    return $render;
  }

  /**
   * {@inheritdoc}
   */
  public function getAttachedAssets(): AttachedAssets {
    $assets = new AttachedAssets();
    $assets->setLibraries([
      'meta_pixel/ajax',
    ]);
    return $assets;
  }

}
