<?php

declare(strict_types=1);

namespace Drupal\meta_pixel\Plugin\MetaPixelEvent;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meta_pixel\Attribute\MetaPixelEvent;
use Drupal\meta_pixel\MetaPixelEventPluginBase;

/**
 * Basic Page View Event.
 *
 * This plugin is different from the others. The plugin just exists so the
 * functionality can be enabled/disabled in the module's settings. We call
 * Page View events a little differently.
 *
 * @see \Drupal\meta_pixel\Controller\PageViewController
 */
#[MetaPixelEvent(
  id: 'custom_event',
  event_name: 'CustomEvent',
  label: new TranslatableMarkup('Custom Event'),
  description: new TranslatableMarkup('A placeholder for sending a custom event.'),
  weight: 0,
)]
class CustomEvent extends MetaPixelEventPluginBase {

  /**
   * {@inheritdoc}
   */
  public function buildEventData(): array {
    $event_data = parent::buildEventData();
    $data = $this->getData();
    return array_merge($event_data, $data);
  }

}
