/**
 * @file
 * Meta Pixel AJAX command handler.
 */

(function (Drupal, drupalSettings) {
  'use strict';

  /**
   * Custom AJAX command to fire Meta Pixel events.
   */
  Drupal.AjaxCommands.prototype.metaPixelTrack = function (ajax, response, status) {
    if (typeof fbq === 'function') {
      const options = { eventID: response.eventId };
      if (drupalSettings.metaPixel.debug) {
        console.log('Ajax Command', response.eventName, response.eventData, options);
      }
      fbq('track', response.eventName, response.eventData, options);
    }
  };

})(Drupal, drupalSettings);
