<?php

declare(strict_types=1);

namespace Drupal\meta_pixel_commerce\Plugin\MetaPixelEvent;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meta_pixel\Attribute\MetaPixelEvent;

/**
 * Builds AddPaymentInfo event data when payment information is submitted.
 *
 * @see \meta_pixel_commerce_checkout_step_submit()
 */
#[MetaPixelEvent(
  id: 'commerce_add_payment_info',
  event_name: 'AddPaymentInfo',
  label: new TranslatableMarkup('AddPaymentInfo (Commerce)'),
  description: new TranslatableMarkup('Fires after adding payment information to an order.'),
  weight: 0,
)]
class AddPaymentInfoEvent extends CommerceMetaPixelEventPluginBase {

  /**
   * {@inheritdoc}
   */
  public function applies(array $data): bool {
    return !empty($data['order']);
  }

  /**
   * {@inheritdoc}
   */
  public function buildEventData(): array {
    $event_data = parent::buildEventData();
    $data = $this->getData();
    $order = $data['order'] ?? NULL;
    $order_event_data = $this->buildOrderEventData($order);
    return array_merge($event_data, $order_event_data);
  }

}
