<?php

declare(strict_types=1);

namespace Drupal\meta_pixel_commerce\Plugin\MetaPixelEvent;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meta_pixel\Attribute\MetaPixelEvent;

/**
 * Builds InitiateCheckout event data when a user starts the checkout process.
 *
 * @see \meta_pixel_commerce_form_commerce_checkout_flow_alter()
 */
#[MetaPixelEvent(
  id: 'commerce_initiate_checkout',
  event_name: 'InitiateCheckout',
  label: new TranslatableMarkup('InitiateCheckout (Commerce)'),
  description: new TranslatableMarkup('Fires on the first page of the checkout flow.'),
  weight: 0,
)]
class InitiateCheckoutEvent extends CommerceMetaPixelEventPluginBase {

  /**
   * {@inheritdoc}
   */
  public function applies(array $data): bool {
    return !empty($data['order']);
  }

  /**
   *
   */
  public function buildEventData(): array {
    $event_data = parent::buildEventData();
    $data = $this->getData();
    $order = $data['order'] ?? NULL;
    $order_event_data = $this->buildOrderEventData($order);
    return array_merge($event_data, $order_event_data);
  }

}
