<?php

declare(strict_types=1);

namespace Drupal\meta_pixel_commerce\Plugin\MetaPixelEvent;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meta_pixel\Attribute\MetaPixelEvent;

/**
 * Builds Purchase event data when an order is placed.
 *
 * @see \Drupal\meta_pixel_commerce\EventSubscriber\PurchaseSubscriber
 */
#[MetaPixelEvent(
  id: 'commerce_purchase',
  event_name: 'Purchase',
  label: new TranslatableMarkup('Purchase (Commerce)'),
  description: new TranslatableMarkup('Fires when an order is placed.'),
  weight: 0,
)]
class PurchaseEvent extends CommerceMetaPixelEventPluginBase {

  /**
   * {@inheritdoc}
   */
  public function applies(array $data): bool {
    return !empty($data['order']);
  }

  /**
   * {@inheritDoc}
   */
  public function buildEventData(): array {
    $event_data = parent::buildEventData();
    $data = $this->getData();
    $order = $data['order'] ?? NULL;
    $order_event_data = $this->buildOrderEventData($order);
    return array_merge($event_data, $order_event_data);
  }

}
