<?php

declare(strict_types=1);

namespace Drupal\meta_pixel\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Meta Pixel event attribute for plugin discovery.
 *
 * Plugin namespace: Plugin\MetaPixelEvent.
 *
 * For PHP 8 attribute usage, see \Drupal\meta_pixel\Attribute\MetaPixelEvent.
 *
 * @see \Drupal\meta_pixel\Plugin\MetaPixelEventPluginManager
 * @see \Drupal\meta_pixel\Attribute\MetaPixelEvent
 * @see plugin_api
 *
 * @Annotation
 */
class MetaPixelEvent extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public string $id;

  /**
   * The Meta event name (e.g., 'ViewContent', 'AddToCart').
   *
   * @var string
   */
  public string $event_name;

  /**
   * The human-readable name of the event.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the event.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The weight of this event plugin.
   *
   * When multiple plugins claim the same event_name, lower weights
   * are processed first.
   *
   * @var int
   */
  public int $weight = 0;

}
