<?php

declare(strict_types=1);

namespace Drupal\meta_pixel\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a Meta Pixel event attribute for plugin discovery.
 *
 * This is the PHP 8 attribute version. For docblock annotations,
 * see \Drupal\meta_pixel\Annotation\MetaPixelEvent.
 *
 * Plugin namespace: Plugin\MetaPixelEvent.
 *
 * @see \Drupal\meta_pixel\Plugin\MetaPixelEventPluginManager
 * @see \Drupal\meta_pixel\Annotation\MetaPixelEvent
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class MetaPixelEvent extends Plugin {

  /**
   * Constructs a MetaPixelEvent attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param string $event_name
   *   The Meta event name (e.g., 'ViewContent', 'AddToCart').
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the event.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) A brief description of the event.
   * @param int $weight
   *   (optional) The weight of this event plugin. When multiple plugins
   *   claim the same event_name, lower weights are processed first.
   *   Defaults to 0.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly string $event_name,
    public readonly TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly int $weight = 0,
    public readonly ?string $deriver = NULL,
  ) {}

}
