<?php

declare(strict_types=1);

namespace Drupal\meta_pixel\Plugin\MetaPixelEvent;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meta_pixel\Attribute\MetaPixelEvent;
use Drupal\meta_pixel\MetaPixelEventPluginBase;

/**
 * Builds CompleteRegistration event data when user accounts are created.
 *
 * @see \meta_pixel_user_insert()
 */
#[MetaPixelEvent(
  id: 'complete_registration',
  event_name: 'CompleteRegistration',
  label: new TranslatableMarkup('Complete Registration'),
  description: new TranslatableMarkup('Fires when when a new user is created.'),
  weight: 0,
)]
class CompleteRegistrationEvent extends MetaPixelEventPluginBase {

  /**
   * {@inheritdoc}
   */
  public function applies(array $data): bool {
    return !empty($data['user']);
  }

  /**
   * {@inheritdoc}
   */
  public function buildEventData(): array {
    $event_data = parent::buildEventData();
    $event_data['status'] = 'registered';
    return $event_data;
  }

}
