<?php

declare(strict_types=1);

namespace Drupal\meta_pixel\Plugin\MetaPixelEvent;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meta_pixel\Attribute\MetaPixelEvent;
use Drupal\meta_pixel\MetaPixelEventPluginBase;

/**
 * Basic Page View Event.
 *
 * This plugin is different from the others. The plugin just exists so the
 * functionality can be enabled/disabled in the module's settings. We call
 * Page View events a little differently.
 *
 * @see \Drupal\meta_pixel\Controller\PageViewController
 */
#[MetaPixelEvent(
  id: 'page_view',
  event_name: 'PageView',
  label: new TranslatableMarkup('Page View'),
  description: new TranslatableMarkup('Fires on any page view.'),
  weight: 0,
)]
class PageViewEvent extends MetaPixelEventPluginBase {

}
