# Metadata Sanitizer

A Drupal 10/11 module that strips metadata (EXIF, XMP, author names)
from uploaded files using the `exiftool` binary.

## Features

- Removes metadata on upload
- Bulk-clean existing files via Drush (`drush metadata_sanitizer:clean`)
- Flexible filters: extensions, filename pattern, MIME types, entity field usage
- Configurable file types and timestamp preservation
- Admin UI form under `/admin/config/media/metadata-sanitizer`
- Verifies `exiftool` availability at runtime

## Requirements

- Drupal 10 or 11
- `exiftool` installed on system path. For example:

  - Debian/Ubuntu:
    ```bash
    sudo apt-get update
    sudo apt-get install -y libimage-exiftool-perl
    ```

  - RHEL/CentOS/Rocky/Alma:
    ```bash
    sudo dnf install -y perl-Image-ExifTool
    # or on older systems:
    sudo yum install -y perl-Image-ExifTool
    ```

  - macOS (Homebrew):
    ```bash
    brew install exiftool
    ```

  - Windows:
    - Download ExifTool from https://exiftool.org/
    - Follow the Windows install instructions there.
    - Ensure `exiftool.exe` is available on the system PATH.

- On DDEV, you can install ExifTool by adding it to `.ddev/config.yaml`:

  ```yaml
  webimage_extra_packages:
    - libimage-exiftool-perl
  ```

## Installation

Install as you would normally install a contributed Drupal module.
For more details, see: https://www.drupal.org/docs/extending-drupal/installing-modules

## Configuration

1. Ensure the `exiftool` binary is installed and available on your server's PATH.
2. Visit **Configuration > Media > Metadata Sanitizer** in the Drupal administration menu.
3. On the configuration page, you can:
    - Enable or disable metadata sanitization.
    - Select which file extensions will be sanitized.
    - Choose whether to preserve original file dates during sanitization.

For further details, see the inline documentation and module help page.

## Usage

- **Automatic**: 
    - New uploads are sanitized if enabled.

- **Manual bulk cleaning** (Drush):

    - Show help and options:
      ```bash
      drush metadata_sanitizer:clean -h
      ```

    - Run with extension filter:
      ```bash
      drush metadata_sanitizer:clean --extensions=jpg,png
      ```

    - Run with entity field filter:
      ```bash
      drush metadata_sanitizer:clean --field=field_document
      ```

    - You can combine options as needed.

## Testing

- Unit and functional tests for requirements and form.
- Functional test for Drush command execution.
- **Drush command integration should be tested manually or in CI scripts,
as Drupal core does not support automated functional Drush command testing.**

## License

GPL-2.0-or-later
