<?php

namespace Drupal\metadata_sanitizer\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Metadata Sanitizer settings.
 */
class MetadataSanitizerSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'metadata_sanitizer_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['metadata_sanitizer.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable metadata sanitization'),
      '#config_target' => 'metadata_sanitizer.settings:enabled',
    ];

    $form['extensions'] = [
      '#type' => 'textfield',
      '#title' => $this->t('File extensions to sanitize'),
      '#description' => $this->t('Comma-separated list, e.g. jpg,png,pdf'),
      '#config_target' => 'metadata_sanitizer.settings:extensions',
    ];

    $form['preserve_dates'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Preserve original file dates'),
      '#config_target' => 'metadata_sanitizer.settings:preserve_dates',
    ];

    return parent::buildForm($form, $form_state);
  }

}
