<?php

namespace Drupal\Tests\metadata_sanitizer\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Functional test for the Metadata Sanitizer settings form.
 */
class MetadataSanitizerFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'claro';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['metadata_sanitizer', 'system'];

  /**
   * The admin user for testing.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * Set up the test.
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser(['administer site configuration']);
    $this->drupalLogin($this->adminUser);
  }

  /**
   * Test the settings form appears and saves configuration.
   */
  public function testSettingsForm() {
    $this->drupalGet('admin/config/media/metadata-sanitizer');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->fieldExists('enabled');
    $this->assertSession()->fieldExists('extensions');
    $this->assertSession()->fieldExists('preserve_dates');

    // Submit the form with new settings.
    $edit = [
      'enabled' => TRUE,
      'extensions' => 'jpg,png',
      'preserve_dates' => TRUE,
    ];
    $this->submitForm($edit, 'Save configuration');

    // Assert the configuration was saved.
    $config = $this->config('metadata_sanitizer.settings');
    $this->assertTrue($config->get('enabled'), 'Metadata sanitization is enabled.');
    $this->assertEquals('jpg,png', $config->get('extensions'), 'Extensions were saved.');
    $this->assertTrue($config->get('preserve_dates'), 'Preserve dates setting saved.');
  }

}
