<?php

namespace Drupal\metatag_page_heading\Plugin\metatag\Tag;

use Drupal\metatag\Plugin\metatag\Tag\MetaNameBase;

/**
 * The standard page heading meta tag, which overrides the page heading.
 *
 * @MetatagTag(
 *   id = "page_heading",
 *   label = @Translation("Page heading (h1)"),
 *   description = @Translation("The text to display in the page heading / title (typically h1) on the page. Often you may want to include [node:title], like: Prefix [node:title] Suffix"),
 *   name = "page_heading",
 *   group = "page_heading",
 *   weight = 10,
 *   type = "label",
 *   secure = FALSE,
 *   multiple = FALSE,
 *   trimmable = TRUE
 * )
 */
class PageHeading extends MetaNameBase {

  /**
   * {@inheritdoc}
   */
  public function getTestOutputExistsXpath(): array {
    return ["//h1"];
  }

  /**
   * {@inheritdoc}
   */
  public function getTestOutputValuesXpath(array $values): array {
    return ["//h1"];
  }

}
