# Metatag Simple Widget

A custom Drupal module that provides a simplified field widget for metatag fields, showing only the most commonly used meta tags: **Title** and **Description**.

## Overview

This module creates a new field widget called "Simplified meta tags form" that can be used on metatag fields. It provides content creators with a clean, simplified interface for managing the most important meta tags without being overwhelmed by the full firehose of available meta tags.

## Features

- **Simplified Interface**: Shows only title and description fields
- **Clean UI**: No overwhelming list of meta tags
- **Per-node Overrides**: Allows content creators to override default meta tags on individual nodes
- **Configurable**: Option to show default values in the form

## Dependencies

Requires the `metatag` module to be installed and enabled

## Installation

This module suite is installed like any other contributed module. For further information, see [Installing Drupal Modules](https://drupal.org/docs/extending-drupal/installing-drupal-modules).

## Usage

After installing the module:

1. Go to Structure → Content types → Your content type → Manage form display.
2. Locate the Metatag field (assuming you already have a metatag field on your bundle.)
3. Click the gear icon ⚙️ next to the widget selector.
4. Change the widget to "Simplified meta tags form".
5. Optionally configure the widget to show or hide default values like [node:title].

There are no global settings or configuration pages. All behavior is controlled per-field.
