<?php

/**
 * @file
 * Specific hooks for the microsoft_graph_mailer module.
 */

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alter payload data just before sending to the API.
 *
 * This runs even after hook_mail_alter(). This is because this
 * last method just provides the needed values. But this hook is executed
 * later, when all parameters are placed to the right payload structure.
 */
function hook_microsoft_graph_mailer_email_data_alter(array &$payload, array $message) {
  if (isset($message['params']) && isset($message['params']['api'])) {
    $payload['saveToSentItems'] = TRUE;
  }
}

/**
 * @} End of "addtogroup hooks".
 */
