<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines export_entity_filter annotation object.
 *
 * @Annotation
 */
final class ExportEntityFilter extends Plugin {

  /**
   * The plugin ID.
   */
  public readonly string $id;

  /**
   * The human-readable name of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public readonly string $title;

  /**
   * The description of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public readonly string $description;

  /**
   * The entity types that this plugin supports.
   */
  public readonly array $entity_types;

}
