<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Interface for export_entity_filter plugins.
 */
interface ExportEntityFilterInterface {

  /**
   * Returns the translated plugin label.
   */
  public function label(): string;

  /**
   * Returns the entity types that this plugin supports.
   */
  public function getEntityTypes(): array;

  /**
   * Filters an entity.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to filter.
   *
   * @return bool
   *   TRUE if the entity should be exported, FALSE otherwise.
   */
  public function filter(ContentEntityInterface $entity): bool;

}
