<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export\Plugin\ExportEntityFilter;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\migrate_default_content_export\ExportEntityFilterPluginBase;

/**
 * An admin user filter plugin.
 *
 * @ExportEntityFilter(
 *   id = "admin_user_filter",
 *   label = @Translation("Admin User Filter"),
 *   description = @Translation("A filter that excludes the super admin user."),
 *   entity_types = {
 *    "user",
 *   }
 * )
 */
class AdminUserFilter extends ExportEntityFilterPluginBase {

  /**
   * {@inheritdoc}
   */
  public function filter(ContentEntityInterface $entity): bool {
    return $entity->getEntityTypeId() === 'user' && $entity->id() !== '1';
  }

}
