<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export\Plugin\FieldProcessor;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\migrate_default_content_export\FieldProcessorPluginBase;

/**
 * A comment field processor plugin.
 *
 * @FieldProcessor(
 *   id = "comment_field_processor",
 *   label = @Translation("Comment Field Processor"),
 *   description = @Translation("A field processor that removes comment data from exported content.")
 * )
 */
final class CommentFieldProcessor extends FieldProcessorPluginBase {

  /**
   * {@inheritdoc}
   */
  public function isApplicable(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): bool {
    // Comment fields are applicable.
    return $field_definition->getType() === 'comment';
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): mixed {
    // Comment fields should not be exported.
    return NULL;
  }

}
