<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export\Plugin\FieldProcessor;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\migrate_default_content_export\FieldProcessorPluginBase;

/**
 * A path field processor plugin.
 *
 * @FieldProcessor(
 *   id = "path_field_processor",
 *   label = @Translation("Path Field Processor"),
 *   description = @Translation("A field processor that returns the path alias as an array.")
 * )
 */
final class PathFieldProcessor extends FieldProcessorPluginBase {

  /**
   * {@inheritdoc}
   */
  public function isApplicable(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): bool {
    // Path fields are applicable.
    return $field_definition->getType() === 'path';
  }

  /**
   * {@inheritdoc}
   */
  protected function process(mixed $value, FieldDefinitionInterface $field_definition): mixed {
    $value = reset($value);

    // If the value is empty or there is no alias, return NULL.
    if (empty($value) || !isset($value['alias'])) {
      return NULL;
    }

    // Remove the path id.
    unset($value['pid']);

    return $value;
  }

}
