<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for export_entity_filter plugins.
 */
abstract class ExportEntityFilterPluginBase extends PluginBase implements ExportEntityFilterInterface {

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function getEntityTypes(): array {
    return $this->pluginDefinition['entity_types'];
  }

}
