<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\migrate_default_content_export\Annotation\ExportEntityFilter;

/**
 * ExportEntityFilter plugin manager.
 */
final class ExportEntityFilterPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/ExportEntityFilter', $namespaces, $module_handler, ExportEntityFilterInterface::class, ExportEntityFilter::class);
    $this->alterInfo('export_entity_filter_info');
    $this->setCacheBackend($cache_backend, 'export_entity_filter_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function createInstances(array $ids = [], array $configuration = []): array {
    // If no ids are passed, get all the definitions.
    if (empty($ids)) {
      $ids = array_keys($this->getDefinitions());
    }

    // Create instances based on the ids passed.
    $instances = array_map(function ($id) use ($configuration) {
      return $this->createInstance($id, $configuration[$id] ?? []);
    }, $ids);

    return $instances;
  }

}
