<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Interface for migrate_default_content_export_field_processor plugins.
 */
interface FieldProcessorInterface {

  /**
   * Returns the translated plugin label.
   */
  public function label(): string;

  /**
   * Check if the field processor is applicable for the given entity and field.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to process.
   * @param string $field_name
   *   The field name to process.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition to process.
   *
   * @return bool
   *   TRUE if the field processor is applicable, FALSE otherwise.
   */
  public function isApplicable(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): bool;

  /**
   * Get the processed value for the given entity and field.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to process.
   * @param string $field_name
   *   The field name to process.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition to process.
   *
   * @return mixed
   *   The processed value.
   */
  public function getValue(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): mixed;

}
