<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\migrate_default_content_export\Annotation\FieldProcessor;

/**
 * FieldProcessor plugin manager.
 */
final class FieldProcessorPluginManager extends DefaultPluginManager implements FieldProcessorPluginManagerInterface {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/FieldProcessor', $namespaces, $module_handler, FieldProcessorInterface::class, FieldProcessor::class);
    $this->alterInfo('field_processor_info');
    $this->setCacheBackend($cache_backend, 'field_processor_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function createInstances(array $ids = [], array $configuration = []): array {
    // If no ids are passed, get all the definitions.
    if (empty($ids)) {
      $ids = array_keys($this->getDefinitions());
    }

    // Create instances based on the ids passed.
    $instances = array_map(function ($id) use ($configuration) {
      return $this->createInstance($id, $configuration[$id] ?? []);
    }, $ids);

    return $instances;
  }

}
