<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export\Plugin\ExportEntityFilter;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\migrate_default_content_export\ExportEntityFilterPluginBase;

/**
 * An anonymous user filter plugin.
 *
 * @ExportEntityFilter(
 *   id = "anonymous_user_filter",
 *   label = @Translation("Anonymous User Filter"),
 *   description = @Translation("A filter that excludes the anonymous user."),
 *   entity_types = {
 *    "user",
 *   }
 * )
 */
class AnonymousUserFilter extends ExportEntityFilterPluginBase {

  /**
   * {@inheritdoc}
   */
  public function filter(ContentEntityInterface $entity): bool {
    return $entity->getEntityTypeId() === 'user' && $entity->id() !== '0';
  }

}
