<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export\Plugin\FieldProcessor;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\migrate_default_content_export\FieldProcessorPluginBase;

/**
 * A layout section field processor plugin.
 *
 * @FieldProcessor(
 *   id = "layout_section_field_processor",
 *   label = @Translation("Layout Section Field Processor"),
 *   description = @Translation("A field processor that returns layout sections as arrays.")
 * )
 */
final class LayoutSectionFieldProcessor extends FieldProcessorPluginBase {

  /**
   * {@inheritdoc}
   */
  public function isApplicable(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): bool {
    return $field_definition->getType() === 'layout_section';
  }

  /**
   * {@inheritdoc}
   */
  public function process($value, FieldDefinitionInterface $field_definition): mixed {
    if (empty($value)) {
      return NULL;
    }

    $sections = array_map(function ($section) {
      return $section['section']->toArray();
    }, $value);

    return $sections;
  }

}
