<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export\Plugin\FieldProcessor;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\migrate_default_content_export\FieldProcessorPluginBase;

/**
 * A password field processor plugin.
 *
 * @FieldProcessor(
 *   id = "password_field_processor",
 *   label = @Translation("Password Field Processor"),
 *   description = @Translation("A field processor that removes password data from exported content.")
 * )
 */
final class PasswordFieldProcessor extends FieldProcessorPluginBase {

  /**
   * {@inheritdoc}
   */
  public function isApplicable(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): bool {
    // Password fields are applicable.
    return $field_definition->getType() === 'password';
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): mixed {
    // Password fields should not be exported.
    return NULL;
  }

}
