<?php

declare(strict_types = 1);

namespace Drupal\migrate_default_content_export\Plugin\FieldProcessor;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\migrate_default_content_export\FieldProcessorPluginBase;

/**
 * A user email field processor plugin.
 *
 * @FieldProcessor(
 *   id = "user_email_field_processor",
 *   label = @Translation("User Email Field Processor"),
 *   description = @Translation("A field processor that replaces real email addresses with fake ones.")
 * )
 *
 * @todo use a hash of the real email address instead so it can be re-imported.
 */
final class UserEmailFieldProcessor extends FieldProcessorPluginBase {

  /**
   * {@inheritdoc}
   */
  public function isApplicable(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): bool {
    // Email fields attached to users are applicable.
    $is_user = $entity->getEntityTypeId() === 'user';
    $is_email = $field_definition->getType() === 'email';

    return $is_user && $is_email;
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(ContentEntityInterface $entity, string $field_name, FieldDefinitionInterface $field_definition): mixed {
    // Real email addresses should not be exported.
    $uuid = $entity->uuid();

    return 'user-' . $uuid . '@example.com';
  }

}
