<?php

declare(strict_types=1);

namespace Drupal\migrate_spip\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\Annotation\Translation;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a SpipRichText annotation object.
 *
 * @ingroup spip_rich_text
 *
 * @SuppressWarnings(PHPMD.ShortVariable)
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class SpipRichText extends Plugin {

  /**
   * Constructs a SpipRichText attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The human-readable name of the SPIP rich text plugin.
   * @param int $weight
   *   (optional) The weight of the plugin, as it should be ordered.
   *   Defaults to 0.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label = NULL,
    public readonly int $weight = 0,
    public readonly ?string $deriver = NULL,
  ) {}

}
