<?php

declare(strict_types=1);

namespace Drupal\migrate_spip;

/**
 * Interface for "SpipRichText" annotated plugin.
 */
interface SpipRichTextInterface {

  /**
   * Constants extracted from SPIP and needed by several plugins.
   *
   * @var string
   */
  const AUTOBR = '<br class="autobr" />';
  const HTML_TAGS_BLOCK = 'address|applet|article|aside|bloc|blockquote|button|caption|center|d[ltd]|div|fieldset|figure|figcaption|footer|form|h[1-6r]|hgroup|head|header|iframe|li|map|marquee|nav|noscript|object|ol|pre|section|script|style|table|tbody|thead|tr|td|th|textarea|ul|drupal-media';

  /**
   * Apply plugin instance converting for SPIP rich text format.
   *
   * @param string $text
   *   The plain text.
   *
   * @return string
   *   The processed text.
   */
  public function apply(string $text): string;

}
