<?php

namespace Drupal\mile\Menu;

use Drupal\Core\Menu\MenuLinkTreeInterface;
use Drupal\Core\Menu\MenuTreeParameters;

/**
 * Decorates menu link tree build.
 */
class MileMenuLinkTreeDecorator implements MenuLinkTreeInterface {

  /**
   * Class being decorated.
   *
   * @var \Drupal\Core\Menu\MenuLinkTreeInterface
   */
  protected MenuLinkTreeInterface $inner;

  /**
   * {@inheritdoc}
   */
  public function __construct(MenuLinkTreeInterface $inner) {
    $this->inner = $inner;
  }

  /**
   * {@inheritdoc}
   */
  public function load($menu_name, MenuTreeParameters $parameters) {
    return $this->inner->load($menu_name, $parameters);
  }

  /**
   * {@inheritdoc}
   */
  public function transform($tree, array $manipulators) {
    return $this->inner->transform($tree, $manipulators);
  }

  /**
   * {@inheritdoc}
   */
  public function build($tree) {
    $build = $this->inner->build($tree);

    /*
     * Allow loading MILE references when menu is built manually
     * using \Drupal::menuTree().
     */
    if (isset($build['#items'])) {
      $items = $build['#items'];
      _mile_render_menu_items($items);
      $build['#items'] = $items;
    }

    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function getCurrentRouteMenuTreeParameters($menu_name) {
    return $this->inner->getCurrentRouteMenuTreeParameters($menu_name);
  }

  /**
   * {@inheritdoc}
   */
  public function maxDepth() {
    return $this->inner->maxDepth();
  }

  /**
   * {@inheritdoc}
   */
  public function getSubtreeHeight($menu_name) {
    return $this->inner->getSubtreeHeight($menu_name);
  }

  /**
   * {@inheritdoc}
   */
  public function getExpanded($menu_name, array $parents) {
    return $this->inner->getExpanded($menu_name, $parents);
  }

}
