<?php

namespace Drupal\miniorange_2fa\Helper\FormHelper;

use Drupal\miniorange_2fa\MoAuthConstants;
use Drupal\Core\Form\FormStateInterface;

/**
 * @file
 *  This is used to generate kba feilds.
 */
class MoAuthKBAFields
{
  public static function generateKbaFields(array &$form, $question_number, $question_options = [], $pattern = '')
  {

    if ($question_number < 2) {

      $form['mo2f_kba_table'][$question_number]['question'] = [
        '#type' => 'select',
        '#title' => t('@number. Question:', ['@number' => $question_number + 1]),
        '#options' => $question_options,
        '#attributes' => ['style' => 'width:100%'],
        '#required' => TRUE,
      ];
    } else {
      $form['mo2f_kba_table'][$question_number]['question'] = [
        '#type' => 'textfield',
        '#title' => t('@number. Question:', ['@number' => $question_number + 1]),
        '#attributes' => [
          'placeholder' => t('Enter your custom question here'),
          'pattern' => $pattern,
          'style' => 'width:100%',
          'title' => t('Only alphanumeric characters (with question mark) are allowed and include at least three characters.'),
        ],
        '#required' => TRUE,
      ];
    }

    $form['mo2f_kba_table'][$question_number]['answer'] = [
      '#type' => 'textfield',
      '#title' => t('Answer:'),
      '#required' => TRUE,
      '#attributes' => [
        'placeholder' => t('Enter your answer'),
        'class' => ['custom-kba-validation'],
        'id' => 'kba-answer-' . $question_number + 1,
        'pattern' => $pattern,
        'style' => 'width:100%',
        'title' => t(MoAuthConstants::VALIDATION_MESSAGE),
      ],
    ];

    return $form;
  }

}
