﻿# Two Factor Authentication - TFA / Passwordless Login

## Table of contents

  - Introduction
  - Requirements
  - Installation
  - Configuration
  - Custom Hook
  - Setup Guides
  - FAQ
  - Maintainers

## Introduction

  A highly secure & easy to setup Two Factor Authentication (TFA) for your Drupal site.
  Rather than relying on a password alone, which can be phished or guessed, miniOrange Two Factor Authentication (TFA) adds a second layer of security to your Drupal accounts.
  It protects your site from hacks and unauthorized login attempts.

### Features

  - You can login using username + password + two-factor or username + two-factor.
  - It can be deployed for your entire userbase in minutes.
  - All types of phones are supported Smart Phones(iPhone, Android, BlackBerry), Basic Phones, Landlines, etc.
  - If your phone is lost or stolen or discharged, we offer alternate login methods like OTP Over Email and Security Questions (KBA).
  - If your phone is offline, you can use a one-time passcode generated by the app to login.
  - It offers inline registration of users so you can simply activate and configure the module and you are all set.
  - We support multi-factor authentication for all type of phones.
  - Soft Token, QR Code Authentication, Push Notification are supported by miniOrange Authenticator App.
  - Google Authenticator method is supported by both Google Authenticator and Authy App. You can configure Google Authenticator method by Google Authenticator as well as Authy 2-Factor Authentication App.
  - If you want to login from the mobile browser then any authentication method can be converted into Security Questions (KBA) by just one click.

### TOTP Methods (Time-based One-time Passcode)
  - Google Authenticator
  - Microsoft Authenticator
  - Duo Authenticator
  - Authy Authenticator
  - Okta Verify
  - LastPass Authenticator
  - 2FAS Authenticator
  - Zoho OneAuth
  - miniOrange Authenticator

### OTP Methods (One Time Passcode)
  - OTP Over Email
  - OTP Over SMS
  - OTP Over SMS and EMAIL
  - OTP Over Phone

### Other Methods
  - Yubikey Hardware Token
  - Email Verification
  - Security Questions (KBA)
  - QR Code Authentication
  - Push Notifications

## Requirements

  No special requirements.


## Installation
  - Install as you would normally install a contributed Drupal module. See: https://drupal.org/documentation/install/modules-themes/modules-8 for further information.
  - You can also follow [this](https://plugins.miniorange.com/drupal-2fa-setup-guides) guide.

## Configuration

Configure Two-Factor Authentication in **Configuration** » **People** » **miniOrange Two-Factor Authentication**:
  1. **Register with miniOrange**\
    In order to use the module please regiater with the miniOrange. If you already have miniOrange account, enter your username and password to retrieve your account.
  2. **Setup Two-Factor**\
    Once the account is retrieved, go to Setup Two-Factor tab to configure the authentication method you would like to use.
  3. **Want Help**\
     If you need help, click on the _Contact Us_ button at top of tab and submit your query. You can also email us at [drupalsupport@xecurify.com](mailto:drupalsupport@xecurify.com) or [info@xecurify.com](mailto:info@xecurify.com).

## Custom hook (Optional)

Replace the HOOK part with the module name under which you are adding this function.\
You can reduce else-if conditions according to your requirement.

You will get following parameters in the $responseArr array:

```php
$responseArr = array(
    'authType'        => ''   string
    'status'          => ''   string
    'phoneNumber'     => ''   string
    'emailAddress'    => ''   string
    'message'         => ''   string  //Message which will be shown to user. (i.e. The OTP has been sent to your Phone: xxxxxxxxxxx54 and Email: sxxxxxxxxxxh@yxxxx.com. Please enter the OTP you received to Validate)
    'description'     => ''   string  //This is a short description, will be appended under textfield where users will be entering passcodes(OTPs)
    'allowedAttempts' => ''   integer //After which user will be redirected to login page and need to enter credentials (username and password) again. (Default value is 3)
    'authenticator'   => ''   string
);
```

Custom hook:
```php
HOOK_invoke_alter_login_flow_details($responseArr){
if ($responseArr['status'] === 'SUCCESS') {
    // If you want, you can use these values to append in the message/description
    $phoneNumber  = $responseArr['phoneNumber'];
    $emailAddress = $responseArr['emailAddress'];
    $authType     = $responseArr['authType'];

    if ($authType === 'EMAIL') { // For OTP OVER EMAIL
         $responseArr['message'] = 'Enter your custom message';
         $responseArr['description'] = 'Enter your custom description';
         $responseArr['allowedAttempts'] = 'Enter your custom login attempts';
    } elseif ($authType === 'SMS') { // For OTP OVER SMS
        // ...
    } elseif ($authType === 'SMS AND EMAIL') { // For OTP OVER SMS and EMAIL
        // ...
    } elseif ($authType === 'PHONE VERIFICATION') { // For OTP OVER Phone Call
        // ...
    } elseif ($authType === 'MOBILE AUTHENTICATION') { // For QR code Authentication
        // ...
    } elseif ($authType === 'SOFT TOKEN') { // For miniOrange Authenticator
        // ...
    } elseif ($authType === 'PUSH NOTIFICATIONS') { // For Push notification
        // ...
    } elseif ($authType === 'KBA') { // For KBA - Security questions
        // ...
    } elseif ($authType === 'HARDWARE TOKEN') { // For Hardware token (YubiKey)
        // ...
    } elseif ($authType === 'GOOGLE AUTHENTICATOR') { // For all authenticators
        if ($responseArr['authenticator'] === 'GOOGLE AUTHENTICATOR') {
             $responseArr['message'] = 'Enter your custom message';
             $responseArr['description'] = 'Enter your custom description';
             $responseArr['allowedAttempts'] = 'Enter your custom login attempts';
        } elseif ($responseArr['authenticator'] === 'MICROSOFT AUTHENTICATOR') {
            // ...
        } elseif ($responseArr['authenticator'] === 'OKTA VERIFY') {
            // ...
        } elseif ($responseArr['authenticator'] === 'AUTHY AUTHENTICATOR') {
            // ...
        } elseif ($responseArr['authenticator'] === 'LASTPASS AUTHENTICATOR') {
            // ...
        } elseif ($responseArr['authenticator'] === 'DUO AUTHENTICATOR') {
            // ...
        }
    }
}
  return $responseArr;
}
```
## Setup guide

We provide details step by step setup setup guides to configure various 2FA / MFA / TFA methods - https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/two-factor-authentication-tfa-passwordless-login \
**Note:** If you dont find guide for your desired IDP, please contact us at [drupalsupport@xecurify.com](mailto:drupalsupport@xecurify.com)

## FAQ

**Q: How is miniOrange Two Factor Auth (TFA) different?**

**A:** We provide following additional services than other module:
 - We support multiple authentication methods along with their backup method.
 - We support Device Identification. If the user selects Remember device then on the next login from the same device, the user will not be prompted for Two Factor.
 - It is very difficult to login into your site from the mobile browser with Two Factor enabled. We provide you the option that will convert any authentication method into Security Questions(KBA) on a mobile browser.

**Q: How miniOrange Authenticator App is better?**

**A:** We support both miniOrange Authenticator and Google Authenticator apps. But, we recommend you to use miniOrange Authenticator App as
 - miniOrange Authenticator App encrypts all data, whereas Google Authenticator app stores data in plain text.
 - miniOrange Authenticator App has inbuilt Pin-Protection so you can protect your Google Authenticator keys or whole app using pin whereas Google Authenticator is not protected at all.
 - miniOrange has better backup methods.

 **Q: What is difference between Free/Premium version**

**A:** By default, miniOrange Two Factor Authentication (TFA) module for Drupal is free for 1 user forever.
Limited Authentication methods are included in the free version of the module.
Telephony credits are needed for certain authentication methods like Phone Verification, OTP over SMS.
In order to protect more accounts or use enterprise features, you need to upgrade to the premium version of the module.
Besides including all authentication methods, it has inline registration for all users, user management dashboard access, remember device, manage device profiles, customize options for Email and SMS templates, custom redirect after login, customized UI for login screens etc.
You can upgrade to the premium version of the module to have these features.

## Maintainers

Current maintainers:
  - abhay19 - https://www.drupal.org/u/abhay19
  - Arsh Sabharwal (arsh244) - https://www.drupal.org/u/arsh244
  - Gaurav Sood (gauravsood91) - https://www.drupal.org/u/gauravsood91
  - Shrishail Hiremath- https://www.drupal.org/u/shrishail-hiremath

This project has been sponsored by:
* miniOrange Inc\
  miniOrange is a Single Sign-on (SSO) and Identity & Access Management (IAM) provider.
  miniOrange has catered to the security and IAM requirements of government organizations, educational institutions, and NGOs through robust and resilient solutions.
  For more information visit www.miniorange.com, mail us at [drupalsupport@xecurify.com](mailto:drupalsupport@xecurify.com) or call [+1 978 658 9387](tel:+19786589387).
