<?php

namespace Drupal\miniorange_2fa\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines an Authentication Type annotation object.
 *
 * @Annotation
 */
class AuthenticationType extends Plugin {

  /**
   * The plugin ID (machine name).
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the authentication method.
   *
   * @var string
   */
  public $name;

  /**
   * A unique code for this authentication method (e.g., SMS, EMAIL, TOTP).
   *
   * @var string
   */
  public $code;

  /**
   * The authentication category type (e.g., OTP, TOTP).
   *
   * @var string
   */
  public $type;

  /**
   * Description shown to users.
   *
   * @var string
   */
  public $description;

  /**
   * Supported devices for this method.
   *
   * @var array
   */
  public $supported_devices = [];

  /**
   * Whether this method requires user interaction/challenge (e.g. code input).
   *
   * @var bool
   */
  public $challenge = TRUE;

  /**
   * Whether this method uses out-of-band communication (SMS/email).
   *
   * @var bool
   */
  public $oob = FALSE;

  /**
   * Optional documentation link for setup instructions.
   *
   * @var string|null
   */
  public $doc_link = NULL;

  /**
   * Optional video tutorial link.
   *
   * @var string|null
   */
  public $video_link = NULL;

  /**
   * Android app store link.
   *
   * @var string|null
   */
  public $android_link = NULL;

  /**
   * iOS app store link.
   *
   * @var string|null
   */
  public $ios_link = NULL;
}
