<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Annotation\AuthenticationType;
use Drupal\miniorange_2fa\Plugin\OtpAuthenticationTypePluginBase;

/**
 * @AuthenticationType(
 *   id = "otp-over-sms",
 *   name = "OTP Over SMS",
 *   code = "SMS",
 *   type = "OTP",
 *   description = "You will receive an OTP via SMS on your phone.",
 *   supported_devices = {"Feature Phones", "Smartphones"},
 *   challenge = true,
 *   oob = false
 * )
 */
class SmsAuthenticationType extends OtpAuthenticationTypePluginBase {

  /**
   * {@inheritdoc}
   */
  protected function shouldRenderPhoneField(): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  protected function addMethodSpecificWarnings(): void {
    $credits = $this->getRemainingCredits();
    $sms_remaining = $credits['mo_auth_2fa_sms_remaining'] ?? 0;
    
    if ($sms_remaining == 0) {
      $this->addWarningMessage('Zero SMS Transactions Remaining');
    }
    elseif ($sms_remaining <= 10) {
      $this->addWarningMessage('Low SMS Transactions Remaining: @count SMS left.', ['@count' => $sms_remaining]);
    }
  }
}
