/*
International Telephone Input
version: v18.1.8
description: A jQuery plugin for entering international telephone numbers
repository: https://github.com/jackocnr/intl-tel-input.git
license: MIT
author: Jack O'Connor (http://jackocnr.com)
*/

/* Do not remove commented code below, these are the configurable options for telephone input
   Detailed uses if this javaScript is explained in the configure_otp_over_sms.inc file for $form['miniorange_phone']
*/
(function($, Drupal, once) {
  Drupal.behaviors.miniOrange_flags = {
    attach: function (context, settings) {
      {
        once('miniOrange_flags', '#query_phone', context).forEach(
          function (elememt) {
            var input = document.querySelector("#query_phone");

            window.intlTelInput(input,  {
              geoIpLookup: function(callback) {
                fetch("https://ipapi.co/json")
                  .then(function(res) { return res.json(); })
                  .then(function(data) { callback(data.country_code); })
                  .catch(function() { callback("us"); });
              },
              customPlaceholder: function(selectedCountryPlaceholder, selectedCountryData) {
                return "Enter your phone number";
              },
              initialCountry: "auto",
              preferredCountries: ['us', 'gb', 'au', 'in'],
              separateDialCode: true,
              nationalMode: false,
              utilsScript: "utils.js",
              formatOnDisplay: false,
              // hiddenInput: "full",
              // allowDropdown: false,
              // autoInsertDialCode: true,
              // autoPlaceholder: "off",
              // dropdownContainer: document.body,
              // excludeCountries: ["us"],
              // localizedCountries: { 'de': 'Deutschland' },
              // onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
              // placeholderNumberType: "MOBILE",
              // showFlags: false,
            });

            var iti = window.intlTelInputGlobals.getInstance(input);

            function updatePhoneFull() {
              var phoneFullInput = document.querySelector("input[name='phone_full']");
             if (phoneFullInput && iti) {
              phoneFullInput.value = iti.getNumber(intlTelInputUtils.numberFormat.E164);
            }
            }

            ["blur", "countrychange"].forEach(function(event) {
              input.addEventListener(event, updatePhoneFull);
            });

            input.addEventListener("blur", function() {
              var phoneFullInput   = document.querySelector("input[name='phone_full']");
              if (phoneFullInput && iti) {
                phoneFullInput.value = iti.getNumber();
              }
            });
            
            if (typeof Drupal !== 'undefined' && Drupal.Ajax) {
              var original = Drupal.Ajax.prototype.beforeSerialize;
              Drupal.Ajax.prototype.beforeSerialize = function(element, options) {
                updatePhoneFull();
                return original && original.call(this, element, options);
              };
            }
          }
        )
      }
    }
  };
}(jQuery, Drupal, once));
