<?php

namespace Drupal\miniorange_2fa\EventSubscriber;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class MoRouteSubscriber extends RouteSubscriberBase implements EventSubscriberInterface
{
  public function alterRoutes(RouteCollection $collection) {

    // Redirect the user.login.http route to custom protected controller.
    if ($route = $collection->get('user.login.http')) {
      $route->setDefault('_controller', '\Drupal\miniorange_2fa\Controller\MoTfaController::validateLoginRequest');
    }
  }
  /**
   * @inheritdoc
   */
  public static function getSubscribedEvents() :array {

    $events[RoutingEvents::ALTER][] = ['onAlterRoutes', -100];
    return $events;
  }
}
