<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Annotation\AuthenticationType;
use Drupal\miniorange_2fa\Plugin\OtpAuthenticationTypePluginBase;

/**
 * @AuthenticationType(
 *   id = "otp-over-email",
 *   name = "OTP Over EMAIL",
 *   code = "EMAIL",
 *   type = "OTP",
 *   description = "You will receive an OTP (One Time Passcode) via email. You have to enter the OTP to authenticate yourself.",
 *   supported_devices = {"Laptops", "Feature Phones", "Smartphones"},
 *   challenge = true,
 *   oob = false
 * )
 */
class EmailAuthenticationType extends OtpAuthenticationTypePluginBase {
    
    private const FORM_CONTAINER_ID = 'otp-based-methods';

    public function buildConfigurationForm(array $form, \Drupal\Core\Form\FormStateInterface $form_state): array {
      
        $this->setFormTitle($form, self::FORM_CONTAINER_ID);
      
        $form['miniorange_OTP'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Enter the passcode(OTP) you received'),
            '#attributes' => [
                'placeholder' => $this->t('Enter the passcode'),
                'autofocus' => 'true',
                'autocomplete' => 'off',
            ],
        ];

        $form['action'] = ['#type' => 'actions'];
        $form['action']['verify_phone'] = [
          '#type' => 'submit',
          '#button_type' => 'primary',
          '#name' => 'verify_phone',
          '#value' => $this->t('Verify'),
          '#ajax' => [
            'event' => 'click',
            'callback' => [$this, 'handleOtpVerification'],
            'wrapper' => self::FORM_CONTAINER_ID,
          ],
        ];

        return $form;
    }
}
