<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Plugin\QrBasedAuthenticationTypePluginBase;
use Drupal\miniorange_2fa\Annotation\AuthenticationType;

/**
 * QR Code authentication type plugin.
 *
 * @AuthenticationType(
 *   id = "qr_code",
 *   name = @Translation("QR Code Authentication"),
 *   code = "MOBILE AUTHENTICATION",
 *   type = "OTHER",
 *   description = @Translation("You will scan a QR code with your mobile app to authenticate yourself."),
 *   supported_devices = {"mobile", "tablet"},
 *   challenge = true,
 *   oob = true,
 *   ios_link = "https://apps.apple.com/app/id1482362759",
 *   android_link = "https://play.google.com/store/apps/details?id=com.miniorange.android.authenticator",
 *   doc_link = "https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-modules/setup-guides-to-configure-various-2fa-mfa-tfa-methods/qr-code-methods/setup-qr-code-authentication-as-2fa-tfa-method",
 *   video_link = "https://www.youtube.com/watch?v=1XKuDPHCWMc&list=PL2vweZ-PcNpeOYZk3tPy6MoDV8ELT0odI&index=8"
 * )
 */
class QrCodeType extends QrBasedAuthenticationTypePluginBase {

} 