<?php

namespace Drupal\miniorange_webauthn\MoProtector\MoHandler;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class MoFailureHandler implements MoFailureHandlerInterface
{
  public function onFailure(Request $request, ?Throwable $exception = null): Response
  {
    $data = [
      'status' => 'error',
      'errorMessage' => $exception === null ? 'Authentication failed' : $exception->getMessage(),
    ];

    return new JsonResponse($data, Response::HTTP_UNAUTHORIZED);
  }

  public function onAuthenticationFailure(Request $request, ?Throwable $exception): Response
  {
    return $this->onFailure($request, $exception);
  }
}
