<?php

declare(strict_types =1);

namespace Drupal\miniorange_webauthn\MoProtector\MoPredictor;

use Drupal\miniorange_webauthn\MoException\MoUserNotFoundException;
use Symfony\Component\HttpFoundation\Request;
use Drupal\miniorange_webauthn\MoRepo\MoPubKeyCredUserRepoInterface;
use Webauthn\PublicKeyCredentialUserEntity;

final class MoCurrentUserPredictor implements MoUserPredictorInterface
{
  public function __construct(
    private MoPubKeyCredUserRepoInterface $userEntityRepository
  ) {
  }

  /**
   * @throws MoUserNotFoundException
   */
  public function findUser(): PublicKeyCredentialUserEntity
  {
    $user = \Drupal::currentUser();
    $userEntity = $this->userEntityRepository->findOneById((int) $user->id());
    $userEntity !== null || throw MoUserNotFoundException::create('Unable to find the user entity');
    return $userEntity;
  }
}
