<?php

namespace Drupal\miniorange_webauthn\MoRepo;

use Webauthn\PublicKeyCredentialSource;
use Webauthn\PublicKeyCredentialUserEntity;

interface MoPubKeyCredSourceRepoInterface
{
  public function findAllForUserEntity(PublicKeyCredentialUserEntity $pubKeyCredUser);

  public function findByPublicKeyCredentialId(string $publicKeyCredentialId);

  public function createCredentials(PublicKeyCredentialSource $publicKeyCredentialSource, string $label);

  public function checkDuplicate(string $publicKeyCredentialId);

  public function getPublicKeyCredentialSource(string $credentialId);
}
