<?php
namespace Drupal\miniorange_2fa\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\Core\Database\Database;

/**
 * Provides a confirmation form before deleting logs.
 */
class DeleteLogsConfirm extends ConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'delete_logs_confirm';
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete all 2FA logs?');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return Url::fromRoute('miniorange_2fa.report_section');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    Database::getConnection()->truncate('miniorange_2fa_logs')->execute();

    $this->messenger()->addMessage($this->t('All logs have been deleted successfully.'));

    $form_state->setRedirect('miniorange_2fa.report_section');
  }
}
