<?php

/**
 * @file
 * Contains support form for miniOrange 2FA Login Module.
 */
namespace Drupal\miniorange_2fa\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Render\Markup;
use Drupal\Core\Form\FormStateInterface;
use Drupal\miniorange_2fa\MoAuthUtilities;
use Drupal\miniorange_2fa\MoAuthConstants;

/* Showing Licensing form info. */

class MoAuthLicensing extends FormBase
{
    public function getFormId()
    {
        return 'miniorange_2fa_licensing';
    }

    public function buildForm(array $form, FormStateInterface $form_state)
    {


        $mo_Premium_Plan_URL = MoAuthConstants::PORTAL_URL . MoAuthConstants::PREMIUM_PLAN;

        $form['markup_library'] = array(
            '#attached' => array(
                'library' => array(
                    "miniorange_2fa/miniorange_2fa.admin",
                    "miniorange_2fa/miniorange_2fa.main",
                    "core/drupal.dialog.ajax",

                )
            ),
        );

    

        $license_type = \Drupal::config('miniorange_2fa.settings')->get('mo_auth_2fa_license_type');
    
        if (isset($license_type) && $license_type == 'DRUPAL_2FA_PLUGIN') {
          $free_plan_text = 'Thank you for upgrading';
          $premium_plan_text = 'You are on this plan';
        } else {
          $free_plan_text = 'You are on this plan';
          $premium_plan_text = 'Upgrade Now';
        }

        $features = [
            [Markup::create(t('<h1>FREE</h1><h6>For 1 User - Forever</h6>')), Markup::create(t('<h1>PREMIUM</h1><h6>For 1+ Users</h6>')),],
            [Markup::create(t('<p class="mo_2fa_pricing_rate">$0<span style="font-size: 0.5em">/year</span></p>')), Markup::create(t('
                <p class="mo_2fa_pricing_rate" id="premium_price">$65<span style="font-size: 0.5em">/year</span></p>
                <div class="container-inline"><label for="instances_premium">Users</label>&nbsp;&nbsp;
                <select id="instances_premium" name="instances" onchange="Instance_Pricing(this.value)">
                    <option value="10">Upto 10</option>
                    <option value="20">Upto 20</option>
                    <option value="30">Upto 30</option>
                    <option value="40">Upto 40</option>
                    <option value="50">Upto 50</option>
                    <option value="60">Upto 60</option>
                    <option value="70">Upto 70</option>
                    <option value="80">Upto 80</option>
                    <option value="90">Upto 90</option>
                    <option value="100">Upto 100</option>
                    <option value="150">Upto 150</option>
                    <option value="200">Upto 200</option>
                    <option value="250">Upto 250</option>
                    <option value="300">Upto 300</option>
                    <option value="350">Upto 350</option>
                    <option value="400">Upto 400</option>
                    <option value="450">Upto 450</option>
                    <option value="500">Upto 500</option>
                    <option value="600">Upto 600</option>
                    <option value="700">Upto 700</option>
                    <option value="800">Upto 800</option>
                    <option value="900">Upto 900</option>
                    <option value="1000">Upto 1000</option>
                    <option value="2000">More than 1000</option>
                </select></div>')),],
            [Markup::create(t('<a class="button" disabled>'.$free_plan_text.'</a><br><br>')), Markup::create(t('<a class="button" href="' . $mo_Premium_Plan_URL . '" target="_blank">'.$premium_plan_text.'</a> <br><br>')),],
            [Markup::create(t('<h4>FEATURE LIST</h4>')), Markup::create(t('<h4>FEATURE LIST</h4>')),],
            [
                //Features of Free version

                Markup::create(t(
                    '<div class="mo_2fa_feature_list">
                            <ul class="checkmark">
                                <li>All Authentication Methods*</li>
                                <li>Supports all the languages</li>
                                <li>Backup security questions(KBA)</li>
                                <li>Add your Own security questions</li>
                                <li>Customize number of KBA to be asked while login</li>
                                <li>Login with Email address</li>
                                <li>Login with Phone number</li>
                                <li>Override login form username title and description</li>
                                <li>Change app name in Google Authenticator app</li>
                                <li>Multiple device support <small>(configure Authenticator on multiple devices)</small></li>
                                <li>Custom Email Templates</li>
                                <li>Custom SMS Templates</li>
                                <li>Custom OTP length and validity</li>
                                <li>Backdoor URL (in case you get locked out)</li>
                                <li>Custom hook to override messages/text in the login flow</li>
                            </ul>
                           </div>'
                )),

                //Features of Premium version
                Markup::create(t(
                    '<br><h3>ALL THE FEATURES OF FREE </h3><h2> + </h2> <br>
                           <div class="mo_2fa_feature_list">
                            <ul class="checkmark">
                                <li>Support for Headless/decoupled Architecture</li>
                                <li>Passwordless login</li>
                                <li>Enable Role based 2FA</li>
                                <li>Mandate unique 2FA method for each role</li>
                                <li>Enforce 2FA registration for users</li>
                                <li>Select 2FA methods to be configured by end users</li>
                                <li>2FA over Password Reset</li>
                                <li>IP specific 2FA (Trusted IP Address)</li>
                                <li>Remember Device</li>
                                <li>End to End 2FA Integration</li>
                                <li>Basic Email Support Available</li>
                                <li>Opt-in/Opt-out from 2FA</li>
                                <li>Premium GoToMeeting Support Available</li>
                               <br><br><br><br><br>
                            </ul>
                           </div>'
                )),
            ]
        ];


        $form['miniorange_oauth_login_feature_list'] = array(
            '#type' => 'table',
            '#responsive' => TRUE,
            '#rows' => $features,
            '#size' => 3,
            '#attributes' => array(
                'class' => ['mo_upgrade_plans_features mo_2fa_feature_table'],
                'id' => 'plans'
            ),
        );

        $rows = [
            [Markup::create(t('<b>1.</b> Click on the <strong>Upgrade Now</strong> button of the Premium Plan and you will be redirected to miniOrange login console.</li>')), Markup::create(t('<b>4.</b> On successful payment completion, goto <a href=" ' . MoAuthUtilities::get_mo_tab_url('CUSTOMER_SETUP') . ' ">Register/Login</a> tab'))],
            [Markup::create(t('<b>2.</b> Enter your username and password with which you have created an account with us. After that you will be redirected to payment page.')), Markup::create(t('<b>5.</b> Click on the <strong>Check License</strong> button.'))],
            [Markup::create(t('<b>3.</b> Enter your card details and proceed for payment. Upon successful payment, your licence will be updated to the premium version.')), Markup::create(t('<b>6.</b> Clicking the Check Licence button will fetch the latest licence details and all the premium features of the module will be unlocked.'))],
        ];

        $form['miniorange_2fa_how_to_upgrade'] = [
            '#markup' => t('<div id = "steps_upgrade_premium"><br><br><br><br>'),
        ];

        $form['miniorange_2fa_how_to_upgrade_table'] = array(
            '#type' => 'table',
            '#responsive' => TRUE,
            '#header' => [
                'how_to_upgrade' => [
                    'data' => 'HOW TO UPGRADE TO THE PREMIUM VERSION MODULE',
                    'colspan' => 2,
                ],
            ],
            '#rows' => $rows,
            '#attributes' => ['style' => 'border:groove', 'class' => ['mo_how_to_upgrade']],
            '#suffix' => '</div><br>'
        );

        return $form;
    }


    public function submitForm(array &$form, FormStateInterface $form_state)
    {
    }
}
